<?php
/*--------------------------------------------------------------
   LogfileServiceProvider.php 2024-06-15
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/
declare(strict_types=1);


namespace Gambio\Admin\Modules\Logfiles;


use Gambio\Admin\Modules\Logfiles\App\Actions\ActionOverview;
use Gambio\Admin\Modules\Logfiles\Interfaces\LogfileServiceInterface;
use Gambio\Admin\Modules\Logfiles\Repository\LogfileServiceRepository;
use Gambio\Admin\Modules\Logfiles\Services\LogfileService;
use Gambio\Core\Application\DependencyInjection\AbstractServiceProvider;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Configuration\Services\ConfigurationService;

class LogfileServiceProvider extends AbstractServiceProvider
{
    /**
     * @return string[]
     */
    public function provides(): array
    {
        return [
            ActionOverview::class,
            LogfileServiceInterface::class,
            LogfileService::class,
            LogfileServiceRepository::class,
            Path::class
        ];
    }

    /**
     * @return void
     */
    public function register(): void
    {
        $this->application->registerShared(LogfileServiceInterface::class, LogfileService::class)
            ->addArgument(LogfileServiceRepository::class)
            ->addArgument(Path::class);

        $this->application->registerShared(ActionOverview::class)
            ->addArgument(LogfileServiceInterface::class);
        $this->application->registerShared(LogfileServiceRepository::class)
            ->addArgument($this->application)
            ->addArgument(ConfigurationService::class);
    }
}